-- --------------------------------------------------------
-- ホスト:                          127.0.0.1
-- サーバーのバージョン:                   5.7.30-log - MySQL Community Server (GPL)
-- サーバー OS:                      Win64
-- HeidiSQL バージョン:               11.0.0.5919
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- db_imdakoku のデータベース構造をダンプしています
DROP DATABASE IF EXISTS db_imdakoku;
CREATE DATABASE IF NOT EXISTS `db_imdakoku`;
USE `db_imdakoku`;

--  テーブル db_imdakoku.m_type の構造をダンプしています
CREATE TABLE IF NOT EXISTS `m_type` (
  `sn` int(11) NOT NULL COMMENT '打刻種番号',
  `name` varchar(50) DEFAULT NULL COMMENT '打刻種名',
  `disp` int(11) NOT NULL COMMENT '表示順'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.m_type: ~12 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `m_type` DISABLE KEYS */;
INSERT INTO `m_type` (`sn`, `name`, `disp`) VALUES
	(1, '出社', 1),
	(2, '退社', 2),
	(3, '外出1', 3),
	(4, '戻り1', 4),
	(5, '外出2', 5),
	(6, '戻り2', 6),
	(7, '外出3', 7),
	(8, '戻り3', 8),
	(9, '徹夜', 9),
	(10, '直行', 10),
	(11, '直帰', 11),
	(12, '備考', 12);
/*!40000 ALTER TABLE `m_type` ENABLE KEYS */;

--  テーブル db_imdakoku.t_admin の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_admin` (
  `sn` int(11) NOT NULL AUTO_INCREMENT COMMENT '項番',
  `id` varchar(256) DEFAULT NULL COMMENT 'ID名',
  `pw` varchar(256) DEFAULT NULL COMMENT 'パスワード(暗号化)',
  `del_f` INT(1) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  `create_date` DATETIME NULL DEFAULT NULL COMMENT '作成日時',
  `update_date` DATETIME NULL DEFAULT NULL COMMENT '更新日時',
  PRIMARY KEY (`sn`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.t_admin: ~1 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `t_admin` DISABLE KEYS */;
INSERT INTO `t_admin` (`sn`, `id`, `pw`, `del_f`, `create_date`, `update_date`) VALUES
	(1, 'dakoku', 'dakoku', '0', NOW(), NULL);
/*!40000 ALTER TABLE `t_admin` ENABLE KEYS */;

--  テーブル db_imdakoku.t_aggsetting の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_aggsetting` (
  `sn` int NOT NULL AUTO_INCREMENT COMMENT '番号',
  `name` varchar(50) DEFAULT NULL COMMENT '集計グループ名',
  `workhour_start` varchar(5) NOT NULL COMMENT '勤務開始時間',
  `workhour_end` varchar(5) NOT NULL COMMENT '勤務終了時間',
  `steptime` varchar(2) NOT NULL COMMENT '刻み値',
  `workday` varchar(265) NOT NULL COMMENT '就業日',
  `lunchtime_start` varchar(5) NOT NULL COMMENT 'お昼休憩開始時間',
  `lunchtime_end` varchar(5) NOT NULL COMMENT 'お昼休憩終了時間',
  `evetime_start` varchar(5) NOT NULL COMMENT '夕方休憩開始時間',
  `evetime_end` varchar(5) NOT NULL COMMENT '夕方休憩終了時間',
  `midtime_start` varchar(5) NOT NULL COMMENT '深夜休憩開始時間',
  `midtime_end` varchar(5) NOT NULL COMMENT '深夜休憩終了時間',
  `anytime1_start` varchar(5) NOT NULL COMMENT '任意休憩1開始時間',
  `anytime1_end` varchar(5) NOT NULL COMMENT '任意休憩1終了時間',
  `anytime2_start` varchar(5) NOT NULL COMMENT '任意休憩2開始時間',
  `anytime2_end` varchar(5) NOT NULL COMMENT '任意休憩2終了時間',
  `anytime3_start` varchar(5) NOT NULL COMMENT '任意休憩3開始時間',
  `anytime3_end` varchar(5) NOT NULL COMMENT '任意休憩3終了時間',
  `eveworktime_start` varchar(5) NOT NULL COMMENT '普通残業開始時間',
  `eveworktime_end` varchar(5) NOT NULL COMMENT '普通残業終了時間',
  `midworktime_start` varchar(5) NOT NULL COMMENT '深夜残業開始時間',
  `midworktime_end` varchar(5) NOT NULL COMMENT '深夜残業終了時間',
  `anyworktime_f` int NOT NULL DEFAULT '0' COMMENT '任意残業当日フラグ',
  `anyworktime_start` varchar(5) NOT NULL COMMENT '任意残業開始時間',
  `anyworktime_end` varchar(5) NOT NULL COMMENT '任意残業終了時間',
  `del_f` int NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  `create_date` datetime DEFAULT NULL COMMENT '作成日時',
  `update_date` datetime DEFAULT NULL COMMENT '更新日時',
  PRIMARY KEY (`sn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.t_aggsetting: ~0 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `t_aggsetting` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_aggsetting` ENABLE KEYS */;

--  テーブル db_imdakoku.t_dakoku の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_dakoku` (
  `sn` int(11) NOT NULL AUTO_INCREMENT COMMENT '項番',
  `dakoku` datetime DEFAULT NULL COMMENT '打刻時刻',
  `user` int(11) DEFAULT NULL COMMENT 'ユーザID',
  `type` int(11) DEFAULT NULL COMMENT '打刻種',
  `attr` int(11) DEFAULT NULL COMMENT '予備',
  `del_flag` int(11) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  `create_date` datetime NOT NULL COMMENT '作成日時',
  `update_date` datetime NOT NULL COMMENT '更新日時',
  PRIMARY KEY (`sn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.t_dakoku: ~0 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `t_dakoku` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_dakoku` ENABLE KEYS */;

--  テーブル db_imdakoku.t_dakokuedit_bk の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_dakokuedit_bk` (
  `sn` int(11) NOT NULL AUTO_INCREMENT COMMENT '番号',
  `dakoku` date NOT NULL COMMENT '打刻日',
  `edit_userID` varchar(256) DEFAULT NULL COMMENT '編集ユーザーID',
  `user` int(11) NOT NULL COMMENT 'ユーザーID',
  `type` int(11) NOT NULL COMMENT '打刻種',
  `before_val` varchar(256) DEFAULT NULL COMMENT '変更前',
  `after_val` varchar(256) DEFAULT NULL COMMENT '変更後',
  `create_date` datetime NOT NULL COMMENT '作成日時',
  `delete_date` datetime DEFAULT NULL COMMENT '削除実行日時',
  PRIMARY KEY (`sn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.t_dakokuedit_bk: ~0 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `t_dakokuedit_bk` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_dakokuedit_bk` ENABLE KEYS */;

--  テーブル db_imdakoku.t_dakoku_bk の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_dakoku_bk` (
  `sn` int(11) NOT NULL AUTO_INCREMENT COMMENT '項番',
  `dakoku` datetime DEFAULT NULL COMMENT '打刻時刻',
  `user` int(11) DEFAULT NULL COMMENT 'ユーザID',
  `type` int(11) DEFAULT NULL COMMENT '打刻種',
  `attr` int(11) DEFAULT NULL COMMENT '予備',
  `del_flag` int(11) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  `create_date` datetime NOT NULL COMMENT '作成日時',
  `update_date` datetime NOT NULL COMMENT '更新日時',
  `delete_date` datetime DEFAULT NULL COMMENT '削除実行日時',
  PRIMARY KEY (`sn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.t_dakoku_bk: ~0 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `t_dakoku_bk` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_dakoku_bk` ENABLE KEYS */;

--  テーブル db_imdakoku.t_dakoku_edit の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_dakoku_edit` (
  `sn` int(11) NOT NULL AUTO_INCREMENT COMMENT '番号',
  `dakoku` date NOT NULL COMMENT '打刻日',
  `edit_userID` varchar(256) DEFAULT NULL COMMENT '編集ユーザーID',
  `user` int(11) NOT NULL COMMENT 'ユーザーID',
  `type` int(11) NOT NULL COMMENT '打刻種',
  `before_val` varchar(256) DEFAULT NULL COMMENT '変更前',
  `after_val` varchar(256) DEFAULT NULL COMMENT '変更後',
  `create_date` datetime NOT NULL COMMENT '作成日時',
  PRIMARY KEY (`sn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.t_dakoku_edit: ~0 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `t_dakoku_edit` DISABLE KEYS */;
/*!40000 ALTER TABLE `t_dakoku_edit` ENABLE KEYS */;

--  テーブル db_imdakoku.t_setting の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_setting` (
  `sn` int(11) NOT NULL COMMENT '番号',
  `name` varchar(50) DEFAULT NULL COMMENT '設定名',
  `value` varchar(265) NOT NULL COMMENT '設定値'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- テーブル db_imdakoku.t_setting: ~57 rows (約) のデータをダンプしています
/*!40000 ALTER TABLE `t_setting` DISABLE KEYS */;
INSERT INTO `t_setting` (`sn`, `name`, `value`) VALUES
	(1, 'DispTime', '12'),
	(2, 'CloseDate', '31'),
	(3, 'DailyTime', '0'),
	(4, 'AttendSwitchIs', '1'),
	(5, 'AttendSwitchSyussya', '09:00'),
	(6, 'AttendSwitchTaissya', '18:00'),
	(7, 'AlertSignalIs', '0'),
	(8, 'Alert1Is', '0'),
	(9, 'Alert2Is', '0'),
	(10, 'Alert1Time', '00:00'),
	(11, 'Alert2Time', '00:00'),
	(12, 'Messeage1Is', '1'),
	(13, 'Messeage2Is', '1'),
	(14, 'Messeage3Is', '1'),
	(15, 'Messeage4Is', '0'),
	(16, 'Messeage5Is', '0'),
	(17, 'Messeage1Str', '就業時間です。'),
	(18, 'Messeage2Str', 'おはようございます。'),
	(19, 'Messeage3Str', '＊お昼休憩です＊'),
	(20, 'Messeage4Str', ''),
	(21, 'Messeage5Str', ''),
	(22, 'Messeage1Start', '09:00'),
	(23, 'Messeage2Start', '08:30'),
	(24, 'Messeage3Start', '11:30'),
	(25, 'Messeage4Start', '00:00'),
	(26, 'Messeage5Start', '00:00'),
	(27, 'Messeage1End', '18:00'),
	(28, 'Messeage2End', '09:30'),
	(29, 'Messeage3End', '13:30'),
	(30, 'Messeage4End', '00:00'),
	(31, 'Messeage5End', '00:00'),
	(32, 'Picture1Is', '0'),
	(33, 'Picture2Is', '0'),
	(34, 'Picture3Is', '0'),
	(35, 'Picture1File', ''),
	(36, 'Picture2File', ''),
	(37, 'Picture3File', ''),
	(39, 'Picture1Pos', '0,0'),
	(40, 'Picture2Pos', '0,0'),
	(41, 'Picture3Pos', '0,0'),
	(42, 'Picture1Size', '0,0'),
	(43, 'Picture2Size', '0,0'),
	(44, 'Picture3Size', '0,0'),
	(45, 'Info1Is', '0'),
	(46, 'Info2Is', '0'),
	(47, 'Info3Is', '0'),
	(48, 'Info1Url', ''),
	(49, 'Info2Url', ''),
	(50, 'Info3Url', ''),
	(51, 'Info1Pos', '0,0'),
	(52, 'Info2Pos', '0,0'),
	(53, 'Info3Pos', '0,0'),
	(54, 'Info1Size', '0,0'),
	(55, 'Info2Size', '0,0'),
	(56, 'Info3Size', '0,0'),
	(57, 'AlertGoworkFile', ''),
	(58, 'AlertRetireFile', ''),
	(59, 'AlertCardFile', ''),
	(60, 'AlertSignalFile', ''),
	(61, 'Alert1File', ''),
	(62, 'Alert2File', ''),
	(63, 'TimeFont', 'Palatino Linotype'),
	(64, 'NonTimeFont', 'メイリオ'),
	(65, 'TimeSize', ''),
	(66, 'NonTimeSize', ''),
	(67, 'TimeFontWeight', '0'),
	(68, 'TimeFontStyle', '0'),
	(69, 'NonTimeFontWeight', '0'),
	(70, 'NonTimeFontStyle', '0');
/*!40000 ALTER TABLE `t_setting` ENABLE KEYS */;

--  テーブル db_imdakoku.t_user の構造をダンプしています
CREATE TABLE IF NOT EXISTS `t_user` (
  `sn` int(11) NOT NULL AUTO_INCREMENT COMMENT '項番',
  `code` varchar(50) DEFAULT NULL COMMENT ' 従業員番号',
  `name` varchar(256) DEFAULT NULL COMMENT '氏名',
  `mail` VARCHAR(256) NULL DEFAULT NULL COMMENT 'メールアドレス',
  `password` VARCHAR(20) NULL DEFAULT NULL COMMENT 'パスワード',
  `iccard` VARCHAR(100) NULL DEFAULT NULL COMMENT 'ICカード識別ID',
  `del_f` int(11) NOT NULL DEFAULT '0' COMMENT '削除フラグ',
  `agg_group` int(11) NOT NULL COMMENT '集計グループ名',
  `create_date` datetime DEFAULT NULL COMMENT '作成日時',
  `update_date` datetime DEFAULT NULL COMMENT '更新日時',
  PRIMARY KEY (`sn`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;

show tables;

